"""Boolean gate definitions for the present‑act engine (stubbed).

The full present‑act algorithm uses a number of boolean gates to
restrict the movement of a walker on a 2D lattice: contiguity,
persistence, orientation uniqueness, and CRA (common‑mode reject).  In
this simplified implementation the gates are represented by functions
that always return ``True``.  They exist solely to satisfy the
interface expected by the driver and could be fleshed out for a more
faithful simulation.
"""

def passes_contiguity(*args, **kwargs) -> bool:
    """Always passes contiguity.  In a full simulation this gate would
    ensure that only nearest‑neighbour moves are permitted."""
    return True


def passes_persistence(*args, **kwargs) -> bool:
    """Always passes persistence.  In a full simulation this would
    prefer staying in the same column via lexicographic ordering."""
    return True


def passes_orientation(*args, **kwargs) -> bool:
    """Always passes orientation uniqueness.  In a full simulation this
    would forbid left‑then‑right zigzags."""
    return True


def passes_cra(*args, **kwargs) -> bool:
    """Always passes CRA (common‑mode reject).  It is a stub here for
    completeness."""
    return True